/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.redstone_relay;

import com.mrh0.createaddition.blocks.redstone_relay.RedstoneRelay;
import com.mrh0.createaddition.config.Config;
import com.mrh0.createaddition.energy.IWireNode;
import com.mrh0.createaddition.energy.WireType;
import com.mrh0.createaddition.energy.network.EnergyNetwork;
import com.mrh0.createaddition.index.CABlocks;
import com.mrh0.createaddition.network.EnergyNetworkPacket;
import com.mrh0.createaddition.network.IObserveTileEntity;
import com.mrh0.createaddition.network.ObservePacket;
import com.mrh0.createaddition.network.RemoveConnectorPacket;
import com.mrh0.createaddition.util.Util;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3222;

public class RedstoneRelayTileEntity
extends SmartTileEntity
implements IWireNode,
IHaveGoggleInformation,
IObserveTileEntity {
    private final class_2338[] connectionPos = new class_2338[this.getNodeCount()];
    private final int[] connectionIndices = new int[this.getNodeCount()];
    private final WireType[] connectionTypes = new WireType[this.getNodeCount()];
    public IWireNode[] nodeCache = new IWireNode[this.getNodeCount()];
    public static class_243 OFFSET_NORTH = new class_243(0.0, -0.0625, -0.3125);
    public static class_243 OFFSET_WEST = new class_243(-0.3125, -0.0625, 0.0);
    public static class_243 OFFSET_SOUTH = new class_243(0.0, -0.0625, 0.3125);
    public static class_243 OFFSET_EAST = new class_243(0.3125, -0.0625, 0.0);
    public static class_243 IN_VERTICAL_OFFSET_NORTH = new class_243(0.3125, 0.0, -0.0625);
    public static class_243 IN_VERTICAL_OFFSET_WEST = new class_243(-0.0625, 0.0, -0.3125);
    public static class_243 IN_VERTICAL_OFFSET_SOUTH = new class_243(-0.3125, 0.0, 0.0625);
    public static class_243 IN_VERTICAL_OFFSET_EAST = new class_243(0.0625, 0.0, 0.3125);
    public static class_243 OUT_VERTICAL_OFFSET_NORTH = new class_243(-0.3125, 0.0, -0.0625);
    public static class_243 OUT_VERTICAL_OFFSET_WEST = new class_243(-0.0625, 0.0, 0.3125);
    public static class_243 OUT_VERTICAL_OFFSET_SOUTH = new class_243(0.3125, 0.0, 0.0625);
    public static class_243 OUT_VERTICAL_OFFSET_EAST = new class_243(0.0625, 0.0, -0.3125);
    public static final int NODE_COUNT = 8;
    public static final Long MAX_IN = (Long)Config.ACCUMULATOR_MAX_INPUT.get();
    public static final Long MAX_OUT = (Long)Config.ACCUMULATOR_MAX_OUTPUT.get();
    private int demand = 0;
    private EnergyNetwork networkIn;
    private EnergyNetwork networkOut;

    public RedstoneRelayTileEntity(class_2591<?> tileEntityTypeIn, class_2338 pos, class_2680 state) {
        super(tileEntityTypeIn, pos, state);
    }

    @Override
    public IWireNode getNode(int node) {
        if (this.getNodeType(node) == null) {
            this.nodeCache[node] = null;
            return null;
        }
        if (this.nodeCache[node] == null) {
            this.nodeCache[node] = IWireNode.getWireNode(this.field_11863, this.getNodePos(node));
        }
        if (this.nodeCache[node] == null) {
            this.setNode(node, -1, null, null);
        }
        return this.nodeCache[node];
    }

    @Override
    public class_243 getNodeOffset(int node) {
        boolean vertical = (Boolean)this.method_11010().method_11654((class_2769)RedstoneRelay.VERTICAL);
        class_2350 direction = (class_2350)this.method_11010().method_11654((class_2769)RedstoneRelay.HORIZONTAL_FACING);
        if (node > 3) {
            switch (direction) {
                case field_11043: {
                    return vertical ? OUT_VERTICAL_OFFSET_NORTH : OFFSET_NORTH;
                }
                case field_11039: {
                    return vertical ? OUT_VERTICAL_OFFSET_WEST : OFFSET_WEST;
                }
                case field_11035: {
                    return vertical ? OUT_VERTICAL_OFFSET_SOUTH : OFFSET_SOUTH;
                }
                case field_11034: {
                    return vertical ? OUT_VERTICAL_OFFSET_EAST : OFFSET_EAST;
                }
            }
        } else {
            switch (direction) {
                case field_11043: {
                    return vertical ? IN_VERTICAL_OFFSET_NORTH : OFFSET_SOUTH;
                }
                case field_11039: {
                    return vertical ? IN_VERTICAL_OFFSET_WEST : OFFSET_EAST;
                }
                case field_11035: {
                    return vertical ? IN_VERTICAL_OFFSET_SOUTH : OFFSET_NORTH;
                }
                case field_11034: {
                    return vertical ? IN_VERTICAL_OFFSET_EAST : OFFSET_WEST;
                }
            }
        }
        return OFFSET_NORTH;
    }

    @Override
    public boolean isNodeInput(int node) {
        return node < 4;
    }

    @Override
    public boolean isNodeOutput(int node) {
        return !this.isNodeInput(node);
    }

    @Override
    public int getNodeFromPos(class_243 vec) {
        assert (this.field_11863 != null);
        class_2350 dir = (class_2350)this.field_11863.method_8320(this.field_11867).method_11654((class_2769)RedstoneRelay.HORIZONTAL_FACING);
        boolean vertical = (Boolean)this.field_11863.method_8320(this.field_11867).method_11654((class_2769)RedstoneRelay.VERTICAL);
        boolean upper = true;
        vec = vec.method_1023((double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260());
        if (vertical) {
            switch (dir) {
                case field_11043: {
                    upper = vec.method_10216() < 0.5;
                    break;
                }
                case field_11039: {
                    upper = vec.method_10215() > 0.5;
                    break;
                }
                case field_11035: {
                    upper = vec.method_10216() > 0.5;
                    break;
                }
                case field_11034: {
                    upper = vec.method_10215() < 0.5;
                    break;
                }
            }
        } else {
            switch (dir) {
                case field_11043: {
                    upper = vec.method_10215() < 0.5;
                    break;
                }
                case field_11039: {
                    upper = vec.method_10216() < 0.5;
                    break;
                }
                case field_11035: {
                    upper = vec.method_10215() > 0.5;
                    break;
                }
                case field_11034: {
                    upper = vec.method_10216() > 0.5;
                    break;
                }
            }
        }
        for (int i = upper ? 4 : 0; i < (upper ? 8 : 4); ++i) {
            if (this.hasConnection(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public class_2338 getNodePos(int node) {
        return this.connectionPos[node];
    }

    @Override
    public WireType getNodeType(int node) {
        return this.connectionTypes[node];
    }

    @Override
    public int getOtherNodeIndex(int node) {
        if (this.connectionPos[node] == null) {
            return -1;
        }
        return this.connectionIndices[node];
    }

    @Override
    public void setNode(int node, int other, class_2338 pos, WireType type) {
        this.connectionPos[node] = pos;
        this.connectionIndices[node] = other;
        this.connectionTypes[node] = type;
        if (this.networkIn != null) {
            this.networkIn.invalidate();
        }
        if (this.networkOut != null) {
            this.networkOut.invalidate();
        }
    }

    public void read(class_2487 nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        for (int i = 0; i < this.getNodeCount(); ++i) {
            if (!IWireNode.hasNode(nbt, i)) continue;
            this.readNode(nbt, i);
        }
    }

    public void write(class_2487 nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        for (int i = 0; i < this.getNodeCount(); ++i) {
            if (this.getNodeType(i) == null) {
                IWireNode.clearNode(nbt, i);
                continue;
            }
            this.writeNode(nbt, i);
        }
    }

    @Override
    public void removeNode(int other) {
        IWireNode.super.removeNode(other);
        this.invalidateNodeCache();
        this.method_5431();
        if (this.networkIn != null) {
            this.networkIn.invalidate();
        }
        if (this.networkOut != null) {
            this.networkOut.invalidate();
        }
    }

    @Override
    public int getNodeCount() {
        return 8;
    }

    @Override
    public class_2338 getMyPos() {
        return this.field_11867;
    }

    @Override
    public void invalidateNodeCache() {
        for (int i = 0; i < this.getNodeCount(); ++i) {
            this.nodeCache[i] = null;
        }
    }

    public void tick() {
        super.tick();
        assert (this.field_11863 != null);
        if (this.field_11863.method_8608()) {
            return;
        }
        this.networkTick();
    }

    private void networkTick() {
        class_2680 bs;
        if (this.awakeNetwork(this.field_11863)) {
            this.causeBlockUpdate();
        }
        if (!(bs = this.method_11010()).method_27852((class_2248)CABlocks.REDSTONE_RELAY.get())) {
            return;
        }
        if (((Boolean)bs.method_11654((class_2769)RedstoneRelay.POWERED)).booleanValue()) {
            this.networkOut.push(this.networkIn.pull(this.demand));
            this.demand = (int)this.networkIn.demand(this.networkOut.getDemand());
        }
    }

    public void onBlockRemoved(boolean set) {
        for (int i = 0; i < this.getNodeCount(); ++i) {
            if (this.getNodeType(i) == null) continue;
            IWireNode node = this.getNode(i);
            if (node == null) break;
            int other = this.getOtherNodeIndex(i);
            node.removeNode(other);
            node.invalidateNodeCache();
            RemoveConnectorPacket.send(node.getMyPos(), other, this.field_11863);
        }
        this.invalidateNodeCache();
        this.invalidateCaps();
        if (this.networkIn != null) {
            this.networkIn.invalidate();
        }
        if (this.networkOut != null) {
            this.networkOut.invalidate();
        }
        if (set) {
            this.method_11012();
        }
    }

    @Override
    public EnergyNetwork getNetwork(int node) {
        return this.isNodeInput(node) ? this.networkIn : this.networkOut;
    }

    @Override
    public void setNetwork(int node, EnergyNetwork network) {
        if (this.isNodeInput(node)) {
            this.networkIn = network;
        }
        if (this.isNodeOutput(node)) {
            this.networkOut = network;
        }
    }

    @Override
    public boolean isNodeIndicesConnected(int in, int other) {
        return this.isNodeInput(in) == this.isNodeInput(other);
    }

    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
    }

    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        class_239 ray = class_310.method_1551().field_1765;
        if (ray == null) {
            return false;
        }
        int node = this.getNodeFromPos(ray.method_17784());
        ObservePacket.send(this.field_11867, node);
        tooltip.add((class_2561)class_2561.method_43470((String)"    ").method_10852((class_2561)class_2561.method_43471((String)"createaddition.tooltip.relay.info").method_27692(class_124.field_1068)));
        tooltip.add((class_2561)class_2561.method_43470((String)"    ").method_10852((class_2561)class_2561.method_43471((String)"createaddition.tooltip.energy.selected").method_27692(class_124.field_1080)));
        tooltip.add((class_2561)class_2561.method_43470((String)"    ").method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852((class_2561)class_2561.method_43471((String)(this.isNodeInput(node) ? "createaddition.tooltip.energy.input" : "createaddition.tooltip.energy.output")).method_27692(class_124.field_1075)));
        tooltip.add((class_2561)class_2561.method_43470((String)"    ").method_10852((class_2561)class_2561.method_43471((String)"createaddition.tooltip.energy.usage").method_27692(class_124.field_1080)));
        tooltip.add((class_2561)class_2561.method_43470((String)"    ").method_27693(" ").method_27693(Util.format(EnergyNetworkPacket.clientBuff)).method_27693("fe/t").method_27692(class_124.field_1075));
        return true;
    }

    @Override
    public void onObserved(class_3222 player, ObservePacket pack) {
        if (this.isNetworkValid(pack.node())) {
            EnergyNetworkPacket.send(this.field_11867, this.getNetwork(pack.node()).getPulled(), this.getNetwork(pack.node()).getPushed(), player);
        }
    }
}

